#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	/// <summary>
	/// Summary description for IssueReturnReport.
	/// </summary>
	[TestFixture]
	public class BOL_IssueReturnReport : BaseTest 
	{
		private BOL.IssueReturnReport _report;
	
		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			_report = new BOL.IssueReturnReport();
			_report.SetInitialBrokenRules("DlgIssuedReturnedReportCriteria");
		}


		#region constructors

		[Test]
		public void Ctor_Pass()
		{
			Assert.IsTrue(_report != null);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void Ctor_Fail()
		{
		}

		#endregion


		#region properties

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void IssueReturnReport_SortByDate_Pass()
		{
		}
		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void IssueReturnReport_SortByDate_Fail()
		{
		}

		[Test]
		public void IssueReturnReport_RecordCount_Pass()
		{
			_report.StartDate = DateTime.Now.AddDays(-180);
			_report.EndDate = DateTime.Now;
			Assert.IsTrue(_report.RecordCount > 0);
		}
		[Test]
		public void IssueReturnReport_RecordCount_Fail()
		{
			_report.StartDate = DateTime.Now.AddDays(180);
			_report.EndDate = DateTime.Now.AddDays(180);
			Assert.IsTrue(_report.RecordCount == 0);
		}

		[Test]
		public void IssueReturnReport_SearchCriteria_Pass()
		{
			_report.StartDate = DateTime.Now.AddDays(-180);
			_report.EndDate = DateTime.Now;
			Assert.IsTrue(_report.SearchCriteria.Length > 0);
		}
		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void IssueReturnReport_SearchCriteria_Fail()
		{
		}

		#endregion


		#region methods

		[Test]
		public void IssueReturnReport_CreateReport_Pass()
		{
			_report.StartDate = DateTime.Now.AddDays(-180);
			_report.EndDate = DateTime.Now;
			DataSet ds = _report.CreateReport();
			Assert.IsTrue(ds.Tables[0].Rows.Count > 0);
		}
		[Test]
		public void IssueReturnReport_CreateReport_Fail()
		{
			_report.StartDate = DateTime.Now.AddDays(180);
			_report.EndDate = DateTime.Now.AddDays(180);
			DataSet ds = _report.CreateReport();
			Assert.IsTrue(ds.Tables[0].Rows.Count == 0);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.Untestable )]
		public void IssueReturnReport_GenerateAndPrintReport_Pass()
		{
			//Sends report to printer
		}
		[Test]
		[Ignore( StandardIgnoreReasons.Untestable )]
		public void IssueReturnReport_GenerateAndPrintReport_Fail()
		{
			//Sends report to printer
		}

		#endregion
	}
}

#endif
